{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:38:15 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Wintypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, MMSystem, MMUtils, MMObj, MMDSPObj, MMRegs, MMWavOut, MMWaveIO,
  MMPCMSup, MMConect, ExtCtrls, MMWavIn;

type
  TForm1 = class(TForm)
    WaveOut: TMMWaveOut;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    lblBuffersFilled: TLabel;
    lblBuffersDone: TLabel;
    Button2: TButton;
    Button3: TButton;
    RadioGroup1: TRadioGroup;
    procedure Button1Click(Sender: TObject);
    procedure WaveOutBufferLoad(Sender: TObject; lpWaveHdr: PWaveHdr;
                                   var MoreBuffers: Boolean);
    procedure WaveOutBufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure WaveOutBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
  private
  public
    DoMoreBuffers: Boolean;
    BuffersFilled: Longint;
    BuffersDone: Longint;
    wfx: TWaveFormatEx; { Struktur hlt alle Angaben ber gewnschtes Format }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

(* This demo shows you how to play raw 24 or 32 bit data *)

{-- TForm1 ---------------------------------------------------------------}
procedure TForm1.Button1Click(Sender: TObject);
begin
   { first say which format you would play }
   pcmBuildWaveHeader(@wfx, 24, 2, 96000);
   { set the WaveFormat }
   WaveOut.PWaveFormat := @wfx;
   { set some Flags }
   DoMoreBuffers := True;
   BuffersFilled := 0;
   BuffersDone := 0;

   WaveOut.CallBackMode := TMMCBMode(RadioGroup1.ItemIndex);

   { now start the output }
   WaveOut.Start;
end;

{-- TForm1 ---------------------------------------------------------------}
procedure TForm1.WaveOutBufferLoad(Sender: TObject; lpWaveHdr: PWaveHdr;
                                      var MoreBuffers: Boolean);
Var
   i: integer;
   p1: ^Longint;

begin
   { the sound driver needs some data }
   p1 := Pointer(lpWaveHdr^.lpData);
   i := 0;
   { write anything to the buffer }
   while i < lpWaveHdr^.dwBufferLength do
   begin
      p1^ := Random($7FFF);
      inc(p1);
      inc(i, sizeOf(p1^));
   end;

   { set the bytes you have written to the buffer }
   lpWaveHdr^.dwBytesRecorded := lpWaveHdr^.dwBufferLength { := xxxx bytes};
   { set MoreBuffers to True if you have more buffers to write, else False }
   MoreBuffers := DoMoreBuffers;
end;

{-- TForm1 ---------------------------------------------------------------}
procedure TForm1.WaveOutBufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   { the last chance to modify the buffer before we send it to the driver }

   { for example some applications need to add control information in     }
   { the digital audio stream to control external (hardware) devices      }
   inc(BuffersFilled);
   lblBuffersFilled.Caption := IntToStr(BuffersFilled);
end;

{-- TForm1 ---------------------------------------------------------------}
procedure TForm1.WaveOutBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   { the sound driver has returned (played) the buffer }

   inc(BuffersDone);
   lblBuffersDone.Caption := IntToStr(BuffersDone);
end;

{-- TForm1 ---------------------------------------------------------------}
procedure TForm1.Button2Click(Sender: TObject);
begin
   { stop the device }
   WaveOut.Stop;
end;

{-- TForm1 ---------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   { close the device }
   WaveOut.Close;
end;

{-- TForm1 ---------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { stop and close the device }
   WaveOut.Close;
end;

{-- TForm1 ---------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
   DoMoreBuffers := True;
end;

{-- TForm1 ---------------------------------------------------------------}
procedure TForm1.Button3Click(Sender: TObject);
begin
   DoMoreBuffers := False;
end;

end.
